/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.rendimientos;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.ComprobanteRendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Cuenta;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Retenido;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rendimiento
extends ObjetoModeloSucesorValidable<Iva>
implements InformacionEditable<Rendimiento>,
Exportable,
Importable {
    private static final long serialVersionUID = 8985281116003134300L;
    public static final String CC_COMPROBANTES_RETENCION = "comprobantesRetencion";
    public static final String C_CUENTAS = "tieneCuentas";
    private Retenido retenido = new Retenido("retenido", "idRetenido", "6");
    private Cuenta cuentaAhorro;
    private Cuenta cuentaExcenta;
    private boolean tieneCuentas;
    private final List<ComprobanteRendimiento> comprobantesRetencion;

    public Rendimiento() {
        this.retenido.setPropietario((ObjetoModelo)this);
        this.cuentaAhorro = new Cuenta();
        this.cuentaAhorro.setPropietario((ObjetoModelo)this);
        this.cuentaExcenta = new Cuenta();
        this.cuentaExcenta.setPropietario((ObjetoModelo)this);
        this.comprobantesRetencion = new ArrayList<ComprobanteRendimiento>();
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        resultado = this.retenido.validar();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        resultado = this.cuentaAhorro.validar();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        resultado = this.cuentaExcenta.validar();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public Rendimiento crearCopiaEdicion() {
        Rendimiento copia = new Rendimiento();
        copia.setPropietario((Iva)this.propietario);
        copia.setRetenido(this.retenido.crearCopiaEdicion());
        copia.getRetenido().setPropietario((ObjetoModelo)copia);
        copia.setCuentaAhorro(this.cuentaAhorro.crearCopiaEdicion());
        copia.getCuentaAhorro().setPropietario((ObjetoModelo)copia);
        copia.setCuentaExcenta(this.cuentaExcenta.crearCopiaEdicion());
        copia.getCuentaExcenta().setPropietario((ObjetoModelo)copia);
        copia.setTieneCuentas(this.tieneCuentas);
        return copia;
    }

    public void actualizarInformacion(Rendimiento copiaEdicion) {
        this.getRetenido().actualizarInformacion(copiaEdicion.getRetenido());
        this.getCuentaAhorro().actualizarInformacion(copiaEdicion.getCuentaAhorro());
        this.getCuentaExcenta().actualizarInformacion(copiaEdicion.getCuentaExcenta());
        this.setTieneCuentas(copiaEdicion.isTieneCuentas());
    }

    public void agregarComprobantesRetencion(ComprobanteRendimiento comprobanteRendimiento) {
        comprobanteRendimiento.setPropietario((ObjetoModelo)this);
        this.comprobantesRetencion.add(comprobanteRendimiento);
        this.firePropertyChange(CC_COMPROBANTES_RETENCION, null, this.comprobantesRetencion);
    }

    public boolean eliminarComprobantesRentecion(ComprobanteRendimiento comprobanteRendimiento) {
        boolean eliminado = this.comprobantesRetencion.remove((Object)comprobanteRendimiento);
        if (eliminado) {
            this.firePropertyChange(CC_COMPROBANTES_RETENCION, null, this.comprobantesRetencion);
        }
        return eliminado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        Element elem;
        Node nodo;
        this.getRetenido().importar(elemento, null);
        NodeList nl = elemento.getElementsByTagName("ahorroPN");
        int i = 0;
        while (i < nl.getLength()) {
            nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                elem = (Element)nodo;
                this.getCuentaAhorro().importar(elem, null);
                if (Util.getBigDecimal(this.getCuentaAhorro().getTotalDeposito()).compareTo(BigDecimal.ZERO) != 0) {
                    this.tieneCuentas = true;
                }
            }
            ++i;
        }
        nl = elemento.getElementsByTagName("ctaExenta");
        i = 0;
        while (i < nl.getLength()) {
            nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                elem = (Element)nodo;
                this.getCuentaExcenta().importar(elem, null);
                if (Util.getBigDecimal(this.getCuentaExcenta().getTotalDeposito()).compareTo(BigDecimal.ZERO) != 0) {
                    this.tieneCuentas = true;
                }
            }
            ++i;
        }
        nl = elemento.getElementsByTagName("detRet");
        i = 0;
        while (i < nl.getLength()) {
            nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                elem = (Element)nodo;
                ComprobanteRendimiento comprobanteRetencion = new ComprobanteRendimiento();
                comprobanteRetencion.setPropietario((ObjetoModelo)this);
                comprobanteRetencion.importar(elem, null);
                this.agregarComprobantesRetencion(comprobanteRetencion);
            }
            ++i;
        }
        return this;
    }

    public Retenido getRetenido() {
        return this.retenido;
    }

    public Cuenta getCuentaAhorro() {
        return this.cuentaAhorro;
    }

    public Cuenta getCuentaExcenta() {
        return this.cuentaExcenta;
    }

    public List<ComprobanteRendimiento> getComprobantesRetencion() {
        return this.comprobantesRetencion;
    }

    public void setRetenido(Retenido retenido) {
        this.retenido = retenido;
    }

    public void setCuentaAhorro(Cuenta cuentaAhorro) {
        this.cuentaAhorro = cuentaAhorro;
    }

    public void setCuentaExcenta(Cuenta cuentaExcenta) {
        this.cuentaExcenta = cuentaExcenta;
    }

    public Element exportar(Document documento, Element elemento) {
        Element detRendFin = documento.createElement("detalleRendFinancieros");
        this.exportarRetenido(documento, detRendFin);
        this.exportarRendimientosPorCuentasDeAhorroyExcentas(documento, detRendFin);
        Element em = this.obtenerRetencionesXml(documento);
        detRendFin.appendChild(em);
        return detRendFin;
    }

    private void exportarRetenido(Document documento, Element detRendFin) {
        Element em = documento.createElement("retenido");
        String codTipo = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("6", this.getRetenido().getTipoIdentificacion());
        em.setTextContent(codTipo);
        detRendFin.appendChild(em);
        em = documento.createElement("idRetenido");
        em.setTextContent(this.getRetenido().getIdentificacion());
        detRendFin.appendChild(em);
        this.exportarParteRelacionadaDesdeMarzo2015(documento, detRendFin);
        this.exportarTipoDeRetenidoYRazonSocialDesdeMayo2016(documento, detRendFin);
    }

    private void exportarParteRelacionadaDesdeMarzo2015(Document documento, Element detRendFin) {
        if (((Iva)this.getPropietario()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            Element em = documento.createElement("parteRelFid");
            em.setTextContent(this.getRetenido().getParteRelacionada());
            detRendFin.appendChild(em);
        }
    }

    private void exportarTipoDeRetenidoYRazonSocialDesdeMayo2016(Document documento, Element detRendFin) {
        if (((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            Element em = documento.createElement("tipoRete");
            em.setTextContent(this.getRetenido().getTipoProveedor());
            detRendFin.appendChild(em);
            em = documento.createElement("denoBenefi");
            em.setTextContent(this.getRetenido().getRazonSocial());
            detRendFin.appendChild(em);
        }
    }

    private void exportarRendimientosPorCuentasDeAhorroyExcentas(Document documento, Element detRendFin) {
        Element em = documento.createElement("ahorroPN");
        Element ctaa = documento.createElement("totalDep");
        ctaa.setTextContent(this.getCuentaAhorro().getTotalDeposito());
        em.appendChild(ctaa);
        ctaa = documento.createElement("rendGen");
        ctaa.setTextContent(this.getCuentaAhorro().getRendimientoGenerado());
        em.appendChild(ctaa);
        detRendFin.appendChild(em);
        em = documento.createElement("ctaExenta");
        Element ctae = documento.createElement("totalDep");
        ctae.setTextContent(this.getCuentaExcenta().getTotalDeposito());
        em.appendChild(ctae);
        ctae = documento.createElement("rendGen");
        ctae.setTextContent(this.getCuentaExcenta().getRendimientoGenerado());
        em.appendChild(ctae);
        detRendFin.appendChild(em);
    }

    private Element obtenerRetencionesXml(Document documento) {
        Element retenciones = documento.createElement("retenciones");
        for (ComprobanteRendimiento cr : this.getComprobantesRetencion()) {
            Element detRet = cr.exportar(documento, null);
            retenciones.appendChild(detRet);
        }
        return retenciones;
    }

    public boolean isTieneCuentas() {
        return this.tieneCuentas;
    }

    public void setTieneCuentas(boolean tieneCuentas) {
        boolean oldValue = this.tieneCuentas;
        this.tieneCuentas = tieneCuentas;
        this.firePropertyChange(C_CUENTAS, oldValue, this.tieneCuentas);
    }
}

